/* 
 *  ResourceRequest.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.javafxrefclient.ResourceNotFoundException;
import com.avaya.ccs.api.ResourceI;
import com.avaya.ccs.api.exceptions.InvalidArgumentException;
import com.avaya.ccs.api.exceptions.ObjectInvalidException;

/**
 * This class is a base class for Resource requests.
 */
public abstract class ResourceRequest extends SessionRequest {

    private final String resourceID;

    public ResourceRequest(Logger LOG, String resourceID) {
        super(LOG);
        this.resourceID = resourceID;
    }

    public ResourceI getResource() throws InvalidArgumentException, ObjectInvalidException, ResourceNotFoundException {
        ResourceI resource = getSession().findResource(this.resourceID);
        if (resource == null) {
            throw new ResourceNotFoundException(resourceID);
        } else {
            return resource;
        }
    }
}
